// highArray.java
// demonstruje dziaanie klasy o interfejsie wysokopoziomowym
// uruchomienie programu: C>java HighArrayApp
////////////////////////////////////////////////////////////////
class HighArray
   {
   private long[] a;                 // referencja do tablicy 
   private int nElems;               // liczba elementw tablicy 
   //-----------------------------------------------------------
   public HighArray(int max)         // konstruktor 
      {
      a = new long[max];                 // tworzymy tablic 
      nElems = 0;                        // na razie brak elementw 
      }
   //-----------------------------------------------------------
   public boolean find(long searchKey)
      {                              // szukanie okrelonej wartoci
      int j;
      for(j=0; j<nElems; j++)            // dla kadego elementu...
         if(a[j] == searchKey)           // czy znaleziono?
            break;                       // tak, wyjcie z ptli
      if(j == nElems)                    // doszlimy do koca?
         return false;                   // tak, elementu nie znaleziono 
      else
         return true;                    // nie, element znaleziony 
      }  // end find()
   //-----------------------------------------------------------
   public void insert(long value)    // wstawienie elementu do tablicy 
      {
      a[nElems] = value;             // wstawiamy
      nElems++;                      // zwikszamy licznik elementw 
      }
   //-----------------------------------------------------------
   public boolean delete(long value) // usunicie elementu z tablicy
      {
      int j;
      for(j=0; j<nElems; j++)        // szukamy elementu 
         if( value == a[j] )
            break;
      if(j==nElems)                  // nie znalelimy
         return false;
      else                           // znalelimy
         {
         for(int k=j; k<nElems; k++) // przesuwamy pozostae elementy 
            a[k] = a[k+1];
         nElems--;                   // zmniejszamy licznik elementw 
         return true;
         }
      }  // koniec delete()
   //-----------------------------------------------------------
   public void display()             // wypisuje zawarto tablicy 
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         System.out.print(a[j] + " ");  // ...wypisujemy jego warto
      System.out.println("");
      }
   //-----------------------------------------------------------
   }  // koniec klasy HighArray
////////////////////////////////////////////////////////////////
class HighArrayApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;            // rozmiar tablicy 
      HighArray arr;                // referencja do tablicy
      arr = new HighArray(maxSize); // tworzymy tablic

      arr.insert(77);               // wstawiamy 10 elementw 
      arr.insert(99);
      arr.insert(44);
      arr.insert(55);
      arr.insert(22);
      arr.insert(88);
      arr.insert(11);
      arr.insert(00);
      arr.insert(66);
      arr.insert(33);

      arr.display();                // wypisujemy elementy 

      int searchKey = 35;           // szukamy elementu 35
      if( arr.find(searchKey) )
         System.out.println("Znaleziono " + searchKey);
      else
         System.out.println("Nie znaleziono " + searchKey);

      arr.delete(00);               // usuwamy 3 elementy 
      arr.delete(55);
      arr.delete(99);

      arr.display();                // wypisujemy elementy ponownie
      }  // koniec main()
   }  // koniec klasy HighArrayApp
///////////////////////////////////////////////////////////////////////
